## -*-Tcl-*-
 # ###################################################################
 #  HTML mode - tools for editing HTML documents
 # 
 #  FILE: "htmlEntities.tcl"
 #                                    created: 98-02-15 18.04.08 
 #                                last update: 01-11-03 22.33.13 
 #  Author: Johan Linde
 #  E-mail: <alpha_www_tools@go.to>
 #     www: <http://go.to/alpha_www_tools>
 #  
 # Version: 3.1.4
 # 
 # Copyright 1996-2001 by Johan Linde
 #  
 # This program is free software; you can redistribute it and/or modify
 # it under the terms of the GNU General Public License as published by
 # the Free Software Foundation; either version 2 of the License, or
 # (at your option) any later version.
 # 
 # This program is distributed in the hope that it will be useful,
 # but WITHOUT ANY WARRANTY; without even the implied warranty of
 # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 # GNU General Public License for more details.
 # 
 # You should have received a copy of the GNU General Public License
 # along with this program; if not, write to the Free Software
 # Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 # 
 # ###################################################################
 ##

#===============================================================================
#  Character entities  #
#===============================================================================

proc htmlEntities.tcl {} {}

proc html::AddCommonChars {} {
	global HTMLmodeVars html::SmallCharsMenu html::CapitalCharsMenu
	global html::OtherChars1Menu html::OtherChars2Menu
	set commonChars $HTMLmodeVars(commonChars)
	set pick [lremove -l [concat ${html::SmallCharsMenu} ${html::CapitalCharsMenu} ${html::OtherChars1Menu} ${html::OtherChars2Menu}] $commonChars]
	regsub -all ! $pick "" pick1
	if {![catch {listpick -l -p "Select chars for the commonly used char list" \
	  $pick1} newchars] && $newchars != ""} {
		foreach c $newchars {
			if {[lcontains pick $c]} {
				lappend commonChars $c
			} else {
				lappend commonChars "!$c"
			}
		}
		set commonChars [lsort $commonChars]
		prefs::modifiedModeVar commonChars HTML
		set HTMLmodeVars(commonChars) $commonChars
		menu::buildSome "Character Entities"
		message "New characters added to the common list."
	}
}

proc html::RemoveCommonChars {} {
	global HTMLmodeVars 
	set commonChars $HTMLmodeVars(commonChars)
	if {![catch {listpick -l -p "Select chars to remove from the commonly used char list" \
	  $commonChars} chars] && $chars != ""} {
		set commonChars [lremove -l $commonChars $chars]
		prefs::modifiedModeVar commonChars HTML
		set HTMLmodeVars(commonChars) $commonChars
		menu::buildSome "Character Entities"
		message "Characters removed from the common list."
	}
	
}


#
# Insert special character entity
#
proc html::InsertCharacter {char} {
	global html::SpecialCharacter html::CapCharSpecMenu
	if {[isSelection]} { deleteSelection }
	foreach c [list SpecialCharacter CapCharSpecMenu] {
		if {[info exists html::${c}($char)]} {
			insertText &[set html::${c}($char)]\;
			return
		}
	}
}


proc html::SetEntityKeys {meny} {
	global html::SmallCharsMenu html::CapitalCharsMenu html::OtherChars1Menu html::OtherChars2Menu html::PrefsFolder
	if {[file exists [file join ${html::PrefsFolder} "HTML entity keys"]]} {source [file join ${html::PrefsFolder} "HTML entity keys"]}
	set allkeys [set html::[join $meny ""]Menu]
	foreach key $allkeys {
		set dkey $key
		if {[string index $key 0] == "!"} {
			set dkey "[string index $key 1] [set key [string range $key 2 end]]"
		}
		if {[info exists htmlEntityKeys($key)]} {
			lappend keys [list $htmlEntityKeys($key) $dkey]
		} else {
			lappend keys [list {} $dkey]
		}
	}
	bind::fromArray htmlEntityKeys htmlEntityKeysProc 1 HTML
	if {[eval dialog::adjustBindings [list $meny] newkeys modified 0 $keys] != "Cancel"} {
		foreach key $modified {
			set dkey $key
			if {[lcontains allkeys "![string index $key 0][string range $key 2 end]"]} {
				set dkey [string range $key 2 end]
			}
			if {$newkeys($key) == ""} {unset htmlEntityKeys($dkey) htmlEntityKeysProc($dkey); continue}
			set htmlEntityKeys($dkey) $newkeys($key)
			set htmlEntityKeysProc($dkey) [list html::InsertCharacter $dkey]
		}
	}
	bind::fromArray htmlEntityKeys htmlEntityKeysProc 0 HTML
	html::SaveCache "HTML entity keys" "array set htmlEntityKeys [list [array get htmlEntityKeys]]\rarray set htmlEntityKeysProc [list [array get htmlEntityKeysProc]]"
}

set html::SmallCharsMenu {eth thorn                
             y }

set html::CapitalCharsMenu {ETH THORN  A A^      E`  E^ E I` 
I I^ I  O` O O^     U` U U^  Y Y}

set html::OtherChars1Menu {ampersand {greater than} {less than} {!less-than or equal} {!greater-than or equal}
{!approximately equal to} {!not equal to} {nonbreak space} {!"quotation mark} {!left double quotation}
{!right double quotation} {!left single quotation} {!right single quotation} {!single low quotation}
{!double low quotation} {!left double angle} {!right double angle} {!left single angle}
{!right single angle} {!inverted question mark} {!inverted excl. mark} {!feminine ordinal ind.}
{!masculine ordinal ind.} {superscript one} {superscript two} {superscript three} {!registered sign}
{!copyright sign} {!trade mark sign} !degree {!|broken bar}}

set html::OtherChars2Menu {currency !cent !pound !yen !?euro !florin {!acute accent} !diearesis !cedilla
{!section sign} {!paragraph sign} {soft hyphen} {!en dash} {!em dash} {one half} {one quarter}
{three quarters} {!per mille sign} !ellipsis !macron {!middle dot} !bullet !dagger {!double dagger}
{!micro sign} {!not sign} !plus-minus !divide times {!square root} !infinity !integral}

if {![catch {alpha::package require htmlUtilities}]} {
	loadHtmlUtilities.tcl
} else {

proc html::NewCharVar {var val} {
	global html::SpecialCharacter html::CharacterSpecial
	set html::SpecialCharacter($var) $val 
	set html::CharacterSpecial($val) $var
}

proc html::NewCapCharVar {var men val} {
	global html::SpecialCharacter html::CharacterSpecial html::CapCharSpecMenu
	set html::SpecialCharacter($var) $val 
	set html::CharacterSpecial($val) $var
	set html::CapCharSpecMenu($men) $val
}

html::NewCharVar "" szlig
html::NewCharVar "" agrave
html::NewCharVar "" aacute
html::NewCharVar "" acirc
html::NewCharVar "" atilde
html::NewCharVar "" auml
html::NewCharVar "" aring
html::NewCharVar "" aelig
html::NewCharVar "" ccedil
html::NewCharVar "" egrave
html::NewCharVar "" eacute
html::NewCharVar "" ecirc
html::NewCharVar "" euml
html::NewCharVar "" igrave
html::NewCharVar "" iacute
html::NewCharVar "" icirc
html::NewCharVar "" iuml
set html::CapCharSpecMenu(eth) eth
html::NewCharVar "" ntilde
html::NewCharVar "" ograve
html::NewCharVar "" oacute
html::NewCharVar "" ocirc
html::NewCharVar "" otilde
html::NewCharVar "" ouml
html::NewCharVar "" oslash
html::NewCharVar "" ugrave
html::NewCharVar "" uacute
html::NewCharVar "" ucirc
html::NewCharVar ""	uuml
set html::CapCharSpecMenu(y) yacute
set html::CapCharSpecMenu(thorn) thorn
html::NewCharVar ""	yuml
html::NewCharVar "" "#339"

html::NewCapCharVar "" "" Agrave
html::NewCapCharVar "" "A" Aacute
html::NewCapCharVar "" "A^" Acirc
html::NewCapCharVar "" "" Atilde
html::NewCapCharVar "" "" Auml
html::NewCapCharVar "" "" Aring
html::NewCapCharVar "" "" AElig
html::NewCapCharVar "" "" Ccedil
html::NewCapCharVar "" "E`" Egrave
html::NewCapCharVar "" "" Eacute
html::NewCapCharVar "" "E^" Ecirc
html::NewCapCharVar "" "E" Euml
html::NewCapCharVar "" "I`" Igrave
html::NewCapCharVar "" "I" Iacute
html::NewCapCharVar "" "I^" Icirc
html::NewCapCharVar "" "I" Iuml
set html::CapCharSpecMenu(ETH) ETH
html::NewCapCharVar "" "" Ntilde
html::NewCapCharVar "" "O`" Ograve
html::NewCapCharVar "" "O" Oacute
html::NewCapCharVar "" "O^" Ocirc
html::NewCapCharVar "" "" Otilde
html::NewCapCharVar "" "" Ouml
html::NewCapCharVar "" "" Oslash
html::NewCapCharVar "" "U`" Ugrave
html::NewCapCharVar "" "U" Uacute
html::NewCapCharVar "" "U^" Ucirc
html::NewCapCharVar "" ""	Uuml
set html::CapCharSpecMenu(Y) Yacute
set html::CapCharSpecMenu(THORN) THORN
html::NewCapCharVar "" "" "#338"
html::NewCapCharVar "" "Y" "#376"

set "html::CapCharSpecMenu(quotation mark)"	quot
set html::CapCharSpecMenu(ampersand) amp
set "html::CapCharSpecMenu(less than)" lt
set "html::CapCharSpecMenu(greater than)" gt
set "html::CapCharSpecMenu(nonbreak space)"	nbsp
html::NewCapCharVar "" "inverted excl. mark" "#161"
html::NewCapCharVar "" cent "#162"
html::NewCapCharVar "" pound "#163"
set html::CapCharSpecMenu(currency) "#164"
html::NewCapCharVar "" yen "#165"
html::NewCapCharVar "\\|" "broken bar" "#166"
html::NewCapCharVar "" "section sign" "#167"
html::NewCapCharVar "" diearesis "#168"
html::NewCapCharVar "" "copyright sign" copy
html::NewCapCharVar "" "feminine ordinal ind." "#170"
html::NewCapCharVar "" "left double angle" "#171"
html::NewCapCharVar "" "not sign" "#172"
set "html::CapCharSpecMenu(soft hyphen)" "#173"
html::NewCapCharVar "" "registered sign" reg
html::NewCapCharVar "" macron "#175"
html::NewCapCharVar "" degree "#176"
html::NewCapCharVar "" "plus-minus" "#177"
set "html::CapCharSpecMenu(superscript two)" "#178"
set "html::CapCharSpecMenu(superscript three)" "#179"
html::NewCapCharVar "" "acute accent" "#180"
html::NewCapCharVar "" "micro sign" "#181"
html::NewCapCharVar "" "paragraph sign" "#182"
html::NewCapCharVar "" "middle dot" "#183"
html::NewCapCharVar "" cedilla "#184"
set "html::CapCharSpecMenu(superscript one)" "#185"
html::NewCapCharVar "" "masculine ordinal ind." "#186"
html::NewCapCharVar "" "right double angle" "#187"
set "html::CapCharSpecMenu(one quarter)" "#188"
set "html::CapCharSpecMenu(one half)" "#189"
set "html::CapCharSpecMenu(three quarters)" "#190"
html::NewCapCharVar "" "inverted question mark" "#191"
set html::CapCharSpecMenu(times) "#215"
html::NewCapCharVar "" divide "#247"
html::NewCapCharVar "" "en dash" "#8211"
html::NewCapCharVar "" "em dash" "#8212"
html::NewCapCharVar "" "left single quotation" "#8216"
html::NewCapCharVar "" "right single quotation" "#8217"
html::NewCapCharVar "" "single low quotation" "#8218"
html::NewCapCharVar "" "left double quotation" "#8220"
html::NewCapCharVar "" "right double quotation" "#8221"
html::NewCapCharVar "" "double low quotation" "#8222"
html::NewCapCharVar "" dagger "#8224"
html::NewCapCharVar "" "double dagger" "#8225"
html::NewCapCharVar "" "per mille sign" "#8240"
html::NewCapCharVar "" "left single angle" "#8249"
html::NewCapCharVar "" "right single angle" "#8250"
html::NewCapCharVar "" florin "#402"
html::NewCapCharVar "" bullet "#8226"
html::NewCapCharVar "" ellipsis "#8230"
html::NewCapCharVar "" "trade mark sign" "#8482"
html::NewCapCharVar "" "square root" "#8730"
html::NewCapCharVar "" infinity "#8734"
html::NewCapCharVar "" integral "#8747"
html::NewCapCharVar "" "approximately equal to" "#8776"
html::NewCapCharVar "" "not equal to" "#8800"
html::NewCapCharVar "" "less-than or equal" "#8804"
html::NewCapCharVar "" "greater-than or equal" "#8805"
html::NewCapCharVar "?" euro "#8364"


rename html::NewCharVar ""
rename html::NewCapCharVar ""
}
